// PageSettingAbilityLevel.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingUdisk.h"

#define STOP_PLAY 0

// CLS_PageSettingUdisk dialog

IMPLEMENT_DYNAMIC(CLS_PageSettingUdisk, CDialog)

CLS_PageSettingUdisk::CLS_PageSettingUdisk(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CLS_PageSettingUdisk::IDD, pParent)
{

}

CLS_PageSettingUdisk::~CLS_PageSettingUdisk()
{
}

void CLS_PageSettingUdisk::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_VIDEOLIST, m_lstVideoList);
	DDX_Control(pDX, IDC_COMBO_CHANNEL, m_cboChannel);
	DDX_Control(pDX, IDC_COMBO_PIC, m_cboPos);
	DDX_Control(pDX, IDC_COMBO_CURSTATUS, m_cboCurVideoStatus);
	DDX_Control(pDX, IDC_COMBO_PLAYMODE, m_cboPlayMode);
	DDX_Control(pDX, IDC_COMBO_PLAYCMD, m_cboPlayCmd);
	DDX_Control(pDX, IDC_LIST_CHANNEL_VIDEOLIST, m_lstChannelVideoLst);
	DDX_Control(pDX, IDC_COMBO_CURVIDEO, m_cboCurVideo);
}


BEGIN_MESSAGE_MAP(CLS_PageSettingUdisk, CDialog)

	ON_BN_CLICKED(IDC_BUTTON_UPDATE, &CLS_PageSettingUdisk::OnBnClickedButtonUpdate)
	ON_BN_CLICKED(IDC_BUTTON_SET_PLAYMODE, &CLS_PageSettingUdisk::OnBnClickedButtonSetPlaymode)
	ON_CBN_SELCHANGE(IDC_COMBO_CHANNEL, &CLS_PageSettingUdisk::OnCbnSelchangeComboChannel)
	ON_BN_CLICKED(IDC_BUTTON_SET_PLAYCMD, &CLS_PageSettingUdisk::OnBnClickedButtonSetPlaycmd)
	ON_CBN_SELCHANGE(IDC_COMBO_PIC, &CLS_PageSettingUdisk::OnCbnSelchangeComboPic)
	ON_BN_CLICKED(IDC_BUTTON_SET_CHANNELVIDEO, &CLS_PageSettingUdisk::OnBnClickedButtonSetChannelvideo)
	ON_BN_CLICKED(IDC_BUTTON_ADDLIST, &CLS_PageSettingUdisk::OnBnClickedButtonAddlist)
	ON_BN_CLICKED(IDC_BUTTON_DELLIST, &CLS_PageSettingUdisk::OnBnClickedButtonDellist)
	ON_BN_CLICKED(IDC_BUTTON_SET_CURVIDEO, &CLS_PageSettingUdisk::OnBnClickedButtonSetCurvideo)
END_MESSAGE_MAP()


// CLS_PageSettingUdisk message handlers

BOOL CLS_PageSettingUdisk::OnInitDialog()
{
	CLS_CBasePage::OnInitDialog();
	LoadSurfaceResource();
	// TODO:  Add extra initialization here
	m_lstVideoList.SetExtendedStyle(m_lstVideoList.GetExtendedStyle() | 
		LVS_SHOWSELALWAYS |LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT | LVS_EX_CHECKBOXES);
	InsertColumn(m_lstVideoList,0,GetTextByLan("","No."),LVCFMT_LEFT,60);
	InsertColumn(m_lstVideoList,1,GetTextByLan("ļ","VideoName"),LVCFMT_LEFT,200);
	UpdateVideoList();

	m_lstChannelVideoLst.SetExtendedStyle(m_lstChannelVideoLst.GetExtendedStyle() | 
		LVS_SHOWSELALWAYS |LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT | LVS_EX_CHECKBOXES);

	InsertColumn(m_lstChannelVideoLst,0,GetTextByLan("","No."),LVCFMT_LEFT,60);
	InsertColumn(m_lstChannelVideoLst,1,GetTextByLan("ļ","VideoName"),LVCFMT_LEFT,200);

	int iRet = CreateChannelCombo(m_lLogonID, &m_cboChannel);
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CPageSettingSystem::OnInitDialog] CreateChannelCombo failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
	}

	CreatePosCombo(m_lLogonID, GetComboData(&m_cboChannel), 0, &m_cboPos,POS_WITH_WIN);
	UpdatePicInfo();
	OnBnClickedButtonUpdate();
	m_cboPlayCmd.SetCurSel(0);


	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
void CLS_PageSettingUdisk::OnMainNotify(_MAIN_NOTIFY_DATA* _pData)
{
	int iType = _pData->m_iMsg;
	int iID = _pData->m_lID;
	switch(iType)
	{
	case DEC_WCM_DEC_GETUDISK_VIDEOLISTS: 
		UpdateList(_pData->tParam.tUDiskVideoList);
		break;
	case DEC_WCM_DEC_VIDEO_PLAYSET: 
		{
			CString strCmd;
			if(STOP_PLAY==_pData->tParam.tVideoPlayCmdResult.iPlayCmd)
			{
				strCmd = GetTextByLan("Ϣ:ֹͣ","Info:Stop Play");
			}else{
				strCmd = GetTextByLan("Ϣ:ʼ","Info:Start Play");
			}
			if (NOTIFY_SUCCESS == _pData->tParam.tVideoPlayCmdResult.iResult)
			{
				strCmd += "Success";
			}
			else
			{
				strCmd += "Faild";
			}
			SetDlgItemText(IDC_STATIC_INFO,strCmd);
			break;
		}
	default:
		break;
	}
}
void CLS_PageSettingUdisk::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* pData)
{
	switch(pData->m_iMsg)
	{
	case DEC_PARACHANGE_SET_CHANNEL_VIDEO:
		UpdateSetChannelVideo();
		break;
	case DEC_PARACHANGE_CURVIDEO:
		UpdateCurVideo();
		break;
	case DEC_PARACHANGE_VIDEO_PLAYMODE:
		{
			UpdatePlayMode();
		}
		break;
	default:
		break;
	}
}
void  CLS_PageSettingUdisk::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STATIC_CHANNEL, GetTextByLan("ͨ","Channel No"));
	SetDlgItemText(IDC_STATIC_PIC, GetTextByLan("","Pic No"));
	SetDlgItemText(IDC_STATIC_CURVIDEO, GetTextByLan("ǰļ","Current Video"));
	SetDlgItemText(IDC_STATIC_CURVIDEO_STATUS, GetTextByLan("ǰ״̬","Current Status"));
	SetDlgItemText(IDC_STATIC_PLAYMODE, GetTextByLan("ģʽ","Play Mode"));
	SetDlgItemText(IDC_STATIC_PLAYCMD, GetTextByLan("","Play Cmd"));
	SetDlgItemText(IDC_STATIC_FILELIST, GetTextByLan("UƵб","UDisk Filelist"));
	SetDlgItemText(IDC_BUTTON_SET_PLAYMODE, GetTextByLan("","Set"));
	SetDlgItemText(IDC_BUTTON_SET_PLAYCMD, GetTextByLan("","Set"));
	SetDlgItemText(IDC_BUTTON_SET_CHANNELVIDEO, GetTextByLan("","Set"));
	SetDlgItemText(IDC_BUTTON_UPDATE, GetTextByLan("","Update"));
}
void CLS_PageSettingUdisk::UpdateVideoList()
{	
	UDiskVideoList tUDiskVideoList = {0};
	int iRet = DEC_ClientRecvCommand(m_lLogonID, 0, 0, DEC_COMMAND_GETUDISK_VIDEOLISTS, &tUDiskVideoList, sizeof(UDiskVideoList));
	if (ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingUdisk::UpdateVideoList] DEC_ClientRecvCommand Failed!\
								Ret(%d),CMDID(DEC_COMMAND_GETUDISK_VIDEOLISTS)",iRet);
		return;
	}
	UpdateList(tUDiskVideoList);
}

void CLS_PageSettingUdisk::UpdateList(UDiskVideoList &_tUDiskVideoList)
{
	m_lstVideoList.DeleteAllItems();
	for (int i = 0; i < _tUDiskVideoList.iCount&&i < DEC_MAX_VIDEOLIST_SIZE; i++)
	{
		CString strTmp;
		strTmp.Format("%d",i);
		m_lstVideoList.InsertItem(i,strTmp);
		m_lstVideoList.SetItemText(i,1,_tUDiskVideoList.cVideoName[i]);
	}
}

void CLS_PageSettingUdisk::UpdatePlayMode()
{
	VideoPlayMode tVideoPlayMode = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID,GetComboData(&m_cboChannel),GetComboData(&m_cboPos),CMD_DEC_CFG_VIDEO_PLAYMODE,\
		&tVideoPlayMode,sizeof(VideoPlayMode));
	if(ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingUdisk::UpdatePlayMode] DEC_ClientGetDevConfig Failed! \
								Ret(%d),CMDID(CMD_DEC_CFG_VIDEO_PLAYMODE)",iRet);
		return;
	}
	m_cboPlayMode.SetCurSel(tVideoPlayMode.iPlayMode-1);
}

void CLS_PageSettingUdisk::UpdateCurVideo()
{
	UDiskCurVideo tCurVideo = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID,GetComboData(&m_cboChannel),\
		GetComboData(&m_cboPos),CMD_DEC_CFG_CURVIDEO,&tCurVideo,sizeof(UDiskCurVideo));
	if(ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingUdisk::UpdateCurVideo] DEC_ClientGetDevConfig Failed! \
								Ret(%d),CMDID(CMD_DEC_CFG_CURVIDEO)",iRet);
		return;
	}

	int index = m_cboCurVideo.FindStringExact(-1,tCurVideo.cVideoName);
	if(-1==index)
	{
		m_cboCurVideo.SetWindowText(tCurVideo.cVideoName);
	}else{
		m_cboCurVideo.SetCurSel(index);
	}
	m_cboCurVideoStatus.SetCurSel(tCurVideo.iCurVideoState);
}

void CLS_PageSettingUdisk::UpdateSetChannelVideo()
{
	UDiskSetChannelVideo tChannelVideo = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID,GetComboData(&m_cboChannel),\
		GetComboData(&m_cboPos),CMD_DEC_CFG_SET_CHANNEL_VIDEO,&tChannelVideo,sizeof(UDiskSetChannelVideo));
	if(ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingUdisk::UpdateSetChannelVideo] DEC_ClientGetDevConfig Failed! \
								Ret(%d),CMDID(CMD_DEC_CFG_SET_CHANNEL_VIDEO)",iRet);
		return;
	}
	m_cboCurVideo.ResetContent();
	m_lstChannelVideoLst.DeleteAllItems();
	for(int i = 0; i < tChannelVideo.iVideoNum && i < DEC_MAX_UDISK_CHANNEL_VIDEO; i++)
	{
		CString strNo;
		strNo.Format("%d",i);
		m_lstChannelVideoLst.InsertItem(i,strNo);
		m_lstChannelVideoLst.SetItemText(i,1,tChannelVideo.cVideoName[i]);
		m_cboCurVideo.AddString(tChannelVideo.cVideoName[i]);
	}
}

void CLS_PageSettingUdisk::OnBnClickedButtonUpdate()
{
	// TODO: Add your control notification handler code here
	int iRet = DEC_ClientSendCommand(m_lLogonID, 0, 0, DEC_COMMAND_GETUDISK_VIDEOLISTS, NULL, 0);
	if (ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingUdisk::OnBnClickedButtonUpdate] DEC_ClientSendCommand Failed!\
								Ret(%d),CMDID(DEC_COMMAND_GETUDISK_VIDEOLISTS)",iRet);
	}
}

void CLS_PageSettingUdisk::OnBnClickedButtonSetPlaymode()
{
	// TODO: Add your control notification handler code here
	VideoPlayMode tVideoPlayMode = {0};
	tVideoPlayMode.iPlayMode = m_cboPlayMode.GetCurSel()+1;
	int iRet = DEC_ClientSetDevConfig(m_lLogonID,GetComboData(&m_cboChannel),GetComboData(&m_cboPos),CMD_DEC_CFG_VIDEO_PLAYMODE,\
		&tVideoPlayMode,sizeof(VideoPlayMode));
	if(ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingUdisk::OnBnClickedButtonSetPlaymode] DEC_ClientSetDevConfig Failed! \
								Ret(%d),CMDID(CMD_DEC_CFG_VIDEO_PLAYMODE)",iRet);
		return;
	}

}

void CLS_PageSettingUdisk::OnCbnSelchangeComboChannel()
{
	// TODO: Add your control notification handler code here
	CreatePosCombo(m_lLogonID, GetComboData(&m_cboChannel), 0, &m_cboPos,POS_WITH_WIN);
	UpdatePicInfo();
}

void CLS_PageSettingUdisk::OnBnClickedButtonSetPlaycmd()
{
	// TODO: Add your control notification handler code here
	VideoPlayCmd tVideoPlayCmd = {0};
	tVideoPlayCmd.iPlayCmd = m_cboPlayCmd.GetCurSel();
	int iRet = DEC_ClientSendCommand(m_lLogonID, GetComboData(&m_cboChannel), GetComboData(&m_cboPos), 
		DEC_COMMAND_VIDEO_PLAYSET, &tVideoPlayCmd, sizeof(VideoPlayCmd));
	if (ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingUdisk::OnBnClickedButtonSetPlaycmd] DEC_ClientSendCommand Failed!\
								Ret(%d),CMDID(DEC_COMMAND_VIDEO_PLAYSET)",iRet);
	}
}

void CLS_PageSettingUdisk::OnCbnSelchangeComboPic()
{
	// TODO: Add your control notification handler code here
	UpdatePicInfo();
}

void CLS_PageSettingUdisk::UpdatePicInfo()
{
	UpdateSetChannelVideo();
	UpdatePlayMode();
	UpdateCurVideo();
	
}
void CLS_PageSettingUdisk::OnBnClickedButtonSetChannelvideo()
{
	// TODO: Add your control notification handler code here
	
	UDiskSetChannelVideo tChannelVideo = {0};
	int iCount = m_lstChannelVideoLst.GetItemCount();
	for (int i = 0; i < iCount && i < DEC_MAX_UDISK_CHANNEL_VIDEO; i++)
	{
		strcpy_s(tChannelVideo.cVideoName[i],sizeof(tChannelVideo.cVideoName[i]),m_lstChannelVideoLst.GetItemText(i,1).GetBuffer(0));
		
	}
	tChannelVideo.iVideoNum = min(iCount,DEC_MAX_UDISK_CHANNEL_VIDEO);

	int iRet = DEC_ClientSetDevConfig(m_lLogonID,GetComboData(&m_cboChannel),GetComboData(&m_cboPos),
		CMD_DEC_CFG_SET_CHANNEL_VIDEO,&tChannelVideo,sizeof(UDiskSetChannelVideo));
	if(ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingUdisk::OnBnClickedButtonSetChannelvideo] DEC_ClientSetDevConfig Failed! \
								Ret(%d),CMDID(CMD_DEC_CFG_VIDEO_PLAYMODE)",iRet);
		return;
	}

}

void CLS_PageSettingUdisk::OnBnClickedButtonAddlist()
{
	// TODO: Add your control notification handler code here
	//ȡѡеб
	int iCount = m_lstVideoList.GetItemCount();
	int iChannelCount = m_lstChannelVideoLst.GetItemCount();
	for (int i = 0; i < iCount; i++)
	{
		if(m_lstVideoList.GetCheck(i))
		{
			//뵽Channellist
			CString strNo;
			strNo.Format("%d",iChannelCount);
			
			CString csStr = m_lstVideoList.GetItemText(i,1);
			if(!IsStrInList(csStr))
			{
				m_lstChannelVideoLst.InsertItem(iChannelCount,strNo);
				m_lstChannelVideoLst.SetItemText(iChannelCount++,1,csStr);
				if(DEC_MAX_UDISK_CHANNEL_VIDEO == iChannelCount)
				{
					break;
				}
			}
			
			
		}
	}
}

bool CLS_PageSettingUdisk::IsStrInList(CString csStr)
{
	int iCount = m_lstChannelVideoLst.GetItemCount();
	for (int i = 0; i < iCount; i++)
	{
		
		if(0==m_lstChannelVideoLst.GetItemText(i,1).Compare(csStr))
		{
			return true;
		}
	}
	return false;
}


void CLS_PageSettingUdisk::OnBnClickedButtonDellist()
{
	// TODO: Add your control notification handler code here
	int iCount = m_lstChannelVideoLst.GetItemCount();
	for (int i = iCount-1; i >=0 ; i--)
	{
		if(m_lstChannelVideoLst.GetCheck(i))
		{
			m_lstChannelVideoLst.DeleteItem(i);
		}
	}
	//
	for (int i = 0; i < iCount; i++)
	{
		CString strNo;
		strNo.Format("%d",i);
		m_lstChannelVideoLst.SetItemText(i,0,strNo);
	}

}

void CLS_PageSettingUdisk::OnBnClickedButtonSetCurvideo()
{
	// TODO: Add your control notification handler code here
	UDiskCurVideo tCurVideo = {0};
	int iCount = m_lstChannelVideoLst.GetItemCount();

	CString csVideo;
	m_cboCurVideo.GetWindowText(csVideo);
	strcpy_s(tCurVideo.cVideoName,sizeof(tCurVideo.cVideoName),csVideo.GetBuffer(0));
    tCurVideo.iCurVideoState = m_cboCurVideoStatus.GetCurSel();

	int iRet = DEC_ClientSetDevConfig(m_lLogonID,GetComboData(&m_cboChannel),GetComboData(&m_cboPos),
		CMD_DEC_CFG_CURVIDEO,&tCurVideo,sizeof(UDiskCurVideo));
	if(ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingUdisk::OnBnClickedButtonSetCurvideo] DEC_ClientSetDevConfig Failed! \
								Ret(%d),CMDID(CMD_DEC_CFG_CURVIDEO)",iRet);
		return;
	}
}
